#!/bin/sh
#
#
PROG=ups_monitor
INSTALL_DIR=`pwd`
PROGRAM_DIR=/etc/ups_manager/

echo "Linux INSTALL FOR Power Manager"
#----------------------------------------------------
#	Must run this script as root
#----------------------------------------------------
uid=`id | sed 's/^uid=\([0-9][0-9]*\).*$/\1/'`
if [ $uid -ne 0 ]; then
    echo "Not logged in as root."
    exit 1
fi

#-------------------------------------------------------
#	Check source files
#----------------------------------------------------
# SendMSG.sh
# TimeCfg.conf
# config
# install.linux.sh
# shutdown.sh
# startup.add
# ups_monitor
# ups_status
#-------------------------------------------------------
if [ ! -s $INSTALL_DIR/ups_monitor ];then
	echo "Missing File Error: $INSTALL_DIR/ups_monitor does not exist."
	exit 2
fi
if [ ! -s $INSTALL_DIR/ups_status ];then
	echo "Missing File Error: $INSTALL_DIR/ups_status does not exist."
	exit 2
fi
if [ ! -s $INSTALL_DIR/ups_config ];then
	echo "Missing File Error: $INSTALL_DIR/ups_config does not exist."
	exit 2
fi
if [ ! -s $INSTALL_DIR/shutdown.sh ];then
	echo "Missing File Error: $INSTALL_DIR/shutdown.sh does not exist."
	exit 2
fi
if [ ! -s $INSTALL_DIR/SendMSG.sh ];then
	echo "Missing File Error: $INSTALL_DIR/SendMSG.sh does not exist."
	exit 2
fi
if [ ! -s $INSTALL_DIR/TimeCfg.conf ];then
        echo "Missing File Error: $INSTALL_DIR/TimeCfg.conf does not exist."
	exit 2
fi
if [ ! -s $INSTALL_DIR/startup.add ];then
        echo "Missing File Error: $INSTALL_DIR/startup.add does not exist."
	exit 2
fi

if [ ! -s $INSTALL_DIR/pm.conf ];then
        echo "Missing File Error: $INSTALL_DIR/pm.conf does not exist."
	exit 2
fi
#	==============================================================/
#	Figure out what sort of unix this is
#	==============================================================/
UNAME=""
if [ -f /usr/bin/uname ]; then
	UNAME=`/usr/bin/uname`
fi
if [ -f /bin/uname ];	then
	UNAME=`/bin/uname`
fi
if [ $UNAME = "Linux" ]; then
		echo "Your OS is $UNAME."
else
	echo "OS ERROR: The detected OS is $UNAME, these programs need to run under Linux."
	exit 1
fi
#==============================================================/
#Check and backup previous installation if exists.
#if the previously  installed was found then warnning user and exit the install program.;
#
#    ==============================================================/

echo "Power Manager will be installed to the directory $PROGRAM_DIR."

if [ -d ${PROGRAM_DIR} ];then

	echo "A previously installed Power Manager was found. Please run then Installation program after stop it and remove it!"
	exit 1
fi
#=========================vicly add this =====================================/
#Start copy  file
#==============================================================/
{
	if [ ! -d $PROGRAM_DIR ]; then
	echo ""
	echo "Create $PROGRAM_DIR directory..."
	mkdir $PROGRAM_DIR
	fi
	cd $PROGRAM_DIR
	echo ""
        echo -n "Moving files from $INSTALL_DIR to $PROGRAM_DIR "
        cp $INSTALL_DIR/ups_monitor $PROGRAM_DIR 2> /dev/null
		if [ $? = 0 ]; then
			echo -n "."
		else
			echo " "
			echo "Please stop the ups_monitor background process and reinstall it."
			echo "Installation not completed!"
	 		exit 0
		fi
        cp $INSTALL_DIR/ups_status $PROGRAM_DIR 2> /dev/null
		if [ $? = 0 ]; then
			echo -n "."
		else
			echo " "
			echo "Please stop the ups_monitor background process and reinstall it."
			echo "Installation not completed!"
	 		exit 0
		fi
        cp $INSTALL_DIR/ups_config $PROGRAM_DIR 2> /dev/null
		if [ $? = 0 ]; then
			echo -n "."
		else
			echo ""
			echo "Please stop the ups_monitor background process and reinstall it."
			echo "Installation not completed!"
	 		exit 0
		fi
        cp $INSTALL_DIR/TimeDfg.conf $PROGRAM_DIR 2> /dev/null
		echo -n "."
        cp $INSTALL_DIR/shutdown.sh $PROGRAM_DIR 2> /dev/null
		echo -n "."
        #cp $INSTALL_DIR/Readme $PROGRAM_DIR 2> /dev/null
		#echo -n "."
        cp $INSTALL_DIR/ups_manager $PROGRAM_DIR 2> /dev/null
		echo -n "."
        cp $INSTALL_DIR/SendMSG.sh $PROGRAM_DIR 2> /dev/null
		echo -n "."
		cp $INSTALL_DIR/pm.conf $PROGRAM_DIR 2> /dev/null
		echo -n "."
		cp $INSTALL_DIR/syslog /etc/sysconfig/ -af > /dev/null
        echo "OK."
        chmod 544 $PROGRAM_DIR/ups_monitor 2> /dev/null
        chmod 544 $PROGRAM_DIR/ups_status 2> /dev/null
        chmod 544 $PROGRAM_DIR/ups_config 2> /dev/null

        chmod 744 $PROGRAM_DIR/shutdown.sh 2> /dev/null
        chmod 744 $PROGRAM_DIR/SendMSG.sh 2> /dev/null
		#chmod 644 $PROGRAM_DIR/Readme 2> /dev/null
		chmod 644 $INSTALL_DIR/pm.conf 2> /dev/null
}
#	=========================vicly add this =====================================/
#	Operation after copy file finished
#	Add the start command into the rc.local ,so it will be  start when the system startup.
#	========================================================================================/

{
echo ""

	STARTUP=/etc/rc.d/rc.local
	STARTUP_ADD=${INSTALL_DIR}/startup.add
	echo "Adding entries in $STARTUP ...."

	rm $INSTALL_DIR/startup.tmp* 2> /dev/null
	sed 's/#\/etc\/ups_manager/# \/etc\/ups_manager/' $STARTUP > $INSTALL_DIR/startup.tmp1
	difference=""
	difference=`grep /etc/ups_manager $STARTUP | awk 'index($1,"if")==0 && index($1,"#")==0 {print $1}' | head -1`
	echo "the difference is :"
	echo $difference
	if [ $difference ]; then
		echo "Found an old version for Power Manager installation in $STARTUP startup file:"
		difference=`grep -n /etc/ups_manager $STARTUP | awk 'index($1,"if")==0&&index($1,"#")==0 {print}'`
		echo "LINE $difference"
		answer=""
		while true
		do
			answer=""
			echo -n "Would you like the installation program to remark it for you? (Y)es, (N)o. [y] "
			read answer

			if [ $answer ]; then
				echo ""
			else
				answer="y"
			fi
			if [ $answer = "y" ] || [ $answer = "Y" ]; then
				cat $INSTALL_DIR/startup.tmp1 | awk '{if ((index($0,"/etc/ups_manager") != 0 || index($0,"./ups_manager") != 0) && $1 != "if" && $1 != "#") printf("# "); print}' >> $INSTALL_DIR/startup.tmp2
				cp $INSTALL_DIR/startup.tmp2 $STARTUP
				break
			elif [ $answer != "n" ] && [ $answer != "N" ]; then
				echo "Invalid Input"
			else
				echo "WARNING: More than one entry point of ups_manager in $STARTUP, remark or delete them after installation!"
				break
			fi

		done
		echo ""
		echo "Backup $STARTUP to ${STARTUP}.old.ups_manager."
		cp $STARTUP ${STARTUP}.old.ups_manager
		else
			echo ""
			echo "Backup $STARTUP to ${STARTUP}.old.ups_manager"
			cp $STARTUP ${STARTUP}.old.ups_manager
		fi

		echo "Adding startup command to $STARTUP startup file."
		cat $STARTUP_ADD >> $STARTUP
		rm $INSTALL_DIR/startup.tmp* 2> /dev/null
echo "OK."
echo "Press ENTER to continue..."
read answer
sleep 2
}

#	=========================vicly add this =====================================/
#	Last operate after copy file finished
#	==============================================================/
{
  echo ""
  echo "Configure the parameter."
  sleep 1
  ${PROGRAM_DIR}/ups_config
  sleep 2

echo "Installation completed!"
  echo ""
  echo " Start UPS Power Manager Monitor background process... "

  ${PROGRAM_DIR}/ups_monitor &
}

cd $INSTALL_DIR

sleep 1
exit 0
